/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.variant.hosted;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.web.impl.JfWebConfig;
import io.gitlab.jfronny.libjf.web.impl.host.RequestHandler;
import io.gitlab.jfronny.libjf.web.impl.variant.AbstractWebServer;
import io.gitlab.jfronny.libjf.web.impl.variant.hosted.HttpServer;

public class HostedWebServer
extends AbstractWebServer {
    private HttpServer server = null;
    private final int port;
    private final int maxConnections;

    public HostedWebServer(RequestHandler handler, int port, int maxConnections) {
        super(handler);
        this.port = port;
        this.maxConnections = maxConnections;
    }

    @Override
    public String getServerRoot() {
        return this.getServerRoot(this.server.getPort());
    }

    @Override
    public synchronized void stop() {
        this.emitStop();
        if (this.server != null) {
            try {
                this.server.close();
                this.server.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void queueRestart(Runnable callback) {
        int tmpPort = this.port;
        if (this.server != null) {
            tmpPort = this.server.getPort();
            this.stop();
        } else if (tmpPort == 0) {
            tmpPort = JfWebConfig.findAvailablePort();
        }
        this.handler.clear();
        this.server = new HttpServer(null, tmpPort, this.maxConnections, this.handler, () -> this.performRegistrations());
        this.server.start();
        try {
            this.server.waitUntilReady();
        }
        catch (InterruptedException e) {
            this.stop();
            LibJf.LOGGER.error("Server could not be readied", (Throwable)e);
        }
        this.emitStart();
        callback.run();
    }

    @Override
    public boolean isActive() {
        return this.server != null && this.server.isAlive();
    }
}

